program xyztogen
	
  implicit none

  integer, parameter :: NZ = 103 

  character(len=2), parameter :: atom_name(NZ) = &
             (/'H ','He','Li','Be','B ','C ','N ','O ','F ','Ne', &
               'Na','Mg','Al','Si','P ','S ','Cl','Ar','K ','Ca', &
               'Sc','Ti','V ','Cr','Mn','Fe','Co','Ni','Cu','Zn', &
               'Ga','Ge','As','Se','Br','Kr','Rb','Sr','Y ','Zr', &
               'Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn', &
               'Sb','Te','I ','Xe','Cs','Ba','La','Ce','Pr','Nd', &
               'Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb', &
               'Lu','Hf','Ta','W ','Re','Os','Ir','Pt','Au','Hg', &
               'Tl','Pb','Bi','Po','At','Rn','Fr','Ra','Ac','Th', &
               'Pa','U ','Np','Pu','Am','Cm','Bk','Cf','Es','Fm', &
               'Md','No','Lr'/)

	
  real(8) :: x,y,z,miny,maxy
  real(8), allocatable :: r(:,:)
  character(2), allocatable :: atom_type(:), species_name(:)
  integer :: N1,N2, i,Ncont, Natoms, posible_atom, j, nsp, count
  integer, allocatable :: atom_number(:), species(:), atom_index(:)
  character(2) :: atom, posible_specie
	
  open(24,file='coords.xyz')

  read(24,*)Natoms
  read(24,*)
	
  allocate(atom_type(natoms))
  allocate(r(natoms,3))
  allocate(species(Natoms))
  allocate(atom_number(Natoms))
  allocate(species_name(Natoms))	
  allocate(atom_index(Natoms))
	
  do i=1,Natoms
    species_name='ii'
  enddo

  write(*,*)'NAtoms = ',natoms


  do i=1,Natoms
    read(24,*)atom_type(i), r(i,1), r(i,2), r(i,3)
  enddo

  do i=1,Natoms
    do j=1,NZ
      if(atom_type(i).EQ.atom_name(j)) atom_number(i)=j
    enddo
  enddo	

  species(1)=atom_number(1)
  species_name(1)=atom_type(1)
	
  nsp=1
  count=0

  do i=1,Natoms
    do j=1,nsp
      if(atom_number(i).NE.species(j).and.species(j).NE.0)then
	
        posible_atom=atom_number(i)
        posible_specie=atom_type(i)
        count=count+1
       endif
    enddo
    if(count.EQ.nsp)then
      nsp=nsp+1
      species(nsp)=posible_atom
      species_name(nsp)=posible_specie
    endif
    count = 0
  enddo	
  do i=1,Natoms
    write(*,*)species(i), nsp
  enddo
	
  do i=1,Natoms
    do j=1,nsp	
      if(atom_type(i).EQ.species_name(j))then 
        atom_index(i) = j
        write(*,*)atom_index(i), atom_type(i), species_name(j)
      endif
    enddo
  enddo
	
  open(3,file='coords.gen')

  write(3,*)Natoms,'S'
	
  write(3,'(10A3)')(species_name(i), i=1,nsp)     
     
  do i=1,natoms
    write(3,'(I5,I5,3F10.3)')i,atom_index(i),r(i,1) ,r(i,2),r(i,3)
  enddo
write(3,*)'0.0 0.0 0.0'
write(3,*)'10.48992200    0.00000000    0.00000000'
write(3,*)'0.00000000   15.18400000    0.00000000'
write(3,*)'0.00000000    0.00000000   20.00000000'
	
end
	
