#!/bin/bash

#original by Wendu Ding and Christian F.A. Negre - January 2015
#modified by Ben Rudshteyn - January 2017

#$1 is the .xyz file
#$2 is "molecular" if molecule is not crystallographic

#was first argument provided
if [ -z "$1" ] #will be true if variable is empty
then
	echo "You have to provide an argument for the xyz including the extension, you dummy!"
	exit 0
fi

#definitions
thefolder=$(basename $1 .xyz)
skffolder=$HOME/DFTB_version_1_3/mio-1-1
submission=torque_"$thefolder.sh" #omega
submissionlsf=lsf_"$thefolder.sh" #grace

echo "You are running this .xyz file: $thefolder in $PWD"

#set up the calculations folder
mkdir -p $thefolder
cp $1 $thefolder/coords.xyz

cd $thefolder

#the following loop only creates soft links for necessary .skf files
for elementLeft in `cat coords.xyz | sed '2d' | awk '{print $1}' | sort -u | tr -d '1234567890' | sed '/^$/d' ` #grab just the elements, no numbers or spaces
do
	for elementRight in `cat coords.xyz | sed '2d' |  awk '{print $1}' | sort -u | tr -d '1234567890' | sed '/^$/d'  `
	do
		if [ ! -f $skffolder/"$elementLeft""-""$elementRight"".skf" ] #true if file does not exist
		then
			echo "This is a chemistry emergency! .skf file does not exist! Go find it!" 
			exit 0
		fi
		ln -s $skffolder/"$elementLeft""-""$elementRight"".skf" "$elementLeft""-""$elementRight"".skf"
		#the above command is a soft link not the actual file
	done
done

#set up the input files in the folder
~/DFTB_version_1_3/DFTBscriptfiles_noexecutable/xyztogen-prog.o 
~/DFTB_version_1_3/DFTBscriptfiles_noexecutable/dftb_in-make-opt_all.o
sed "s/namex/$thefolder/g" ~/DFTB_version_1_3/DFTBscriptfiles_noexecutable/torque.sh > $submission #omega
sed "s/namex/$thefolder/g" ~/DFTB_version_1_3/DFTBscriptfiles_noexecutable/lsf.sh > $submissionlsf #grace

#edit the input file if it's molecular
if [ "$2" = "molecular" ]
then
        sed -i '1s/S/C/g' coords.gen
        #next commands delete blank lines
        sed -i '$d' coords.gen  #fourth crystallographic line - orthogonal basis vector
        sed -i '$d' coords.gen  #third crystallographic line - orthogonal basis vector
        sed -i '$d' coords.gen  #second crystallographic line - orthogonal basis vector
        sed -i '$d' coords.gen  #first crystallographic line - lattice origin
		kpointsLine=$(grep -n 'KPointsAndWeights={' dftb_in.hsd | tr -d ':' | awk '{print $1}')
        endOfkpoints=`expr $kpointsLine + 2`
        sed -i -e ""$kpointsLine","$endOfkpoints""d"" dftb_in.hsd
fi


#launch the calculation.
#echo 'running DFTB+'
#qsub $submission
echo "Type when ready: qsub $submission"


