

program dftb_inmake
	
  implicit none
	

  integer, parameter :: NZ = 103 
  real(8) :: x,y,z,miny,maxy
  real(8), allocatable :: r(:,:)
  character(2), allocatable :: atom_type(:), species_name(:)
  integer :: N1,N2, i,Ncont, Natoms, posible_atom, j, nsp, count
  integer, allocatable :: atom_number(:), species(:), atom_index(:)
  character(2) :: atom, posible_specie
  character(9) :: forprinting, forprintingskf, forprintingleft

  character(len=2), parameter :: atom_name(NZ) = &
             (/'H ','He','Li','Be','B ','C ','N ','O ','F ','Ne', &
               'Na','Mg','Al','Si','P ','S ','Cl','Ar','K ','Ca', &
               'Sc','Ti','V ','Cr','Mn','Fe','Co','Ni','Cu','Zn', &
               'Ga','Ge','As','Se','Br','Kr','Rb','Sr','Y ','Zr', &
               'Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn', &
               'Sb','Te','I ','Xe','Cs','Ba','La','Ce','Pr','Nd', &
               'Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb', &
               'Lu','Hf','Ta','W ','Re','Os','Ir','Pt','Au','Hg', &
               'Tl','Pb','Bi','Po','At','Rn','Fr','Ra','Ac','Th', &
               'Pa','U ','Np','Pu','Am','Cm','Bk','Cf','Es','Fm', &
               'Md','No','Lr'/)

	
  open(24,file='coords.xyz')

  read(24,*)Natoms
  read(24,*)
	
  allocate(atom_type(natoms))
  allocate(r(natoms,3))
  allocate(species(Natoms))
  allocate(atom_number(Natoms))
  allocate(species_name(Natoms))	
  allocate(atom_index(Natoms))
	
  do i=1,Natoms
    species_name='ii'
  enddo

  write(*,*)'NAtoms = ',natoms


  do i=1,Natoms
    read(24,*)atom_type(i), r(i,1), r(i,2), r(i,3)
  enddo

  do i=1,Natoms
    do j=1,NZ
      if(atom_type(i).EQ.atom_name(j)) atom_number(i)=j
    enddo
  enddo	

  species(1)=atom_number(1)
  species_name(1)=atom_type(1)
	
  nsp=1
  count=0

  do i=1,Natoms
    do j=1,nsp
      if(atom_number(i).NE.species(j).and.species(j).NE.0)then
        posible_atom=atom_number(i)
	posible_specie=atom_type(i)
        count=count+1
      endif
    enddo
    if(count.EQ.nsp)then
      nsp=nsp+1
      species(nsp)=posible_atom
      species_name(nsp)=posible_specie
    endif
    count = 0
  enddo	
  
  do i=1,Natoms
    write(*,*)species(i), nsp
  enddo
	
  do i=1,Natoms
    do j=1,nsp	
      if(atom_type(i).EQ.species_name(j))then 
	atom_index(i) = j
        write(*,*)atom_index(i), atom_type(i), species_name(j)
      endif
    enddo
  enddo
	
  open(3,file='dftb_in.hsd')


!!!!!!!!!!!!!!!!!!!!!!!!

  write(3,*)'Geometry = GenFormat {'
  write(3,*)'<<< "coords.gen"'
  write(3,*)'}'
  write(3,*)'Driver = ConjugateGradient{'
  write(3,*)'MovedAtoms=1:-1'   
  write(3,*)'MaxForceComponent = 1.0e-6'   
  write(3,*)' MaxSteps= 100000'   
  write(3,*)' OutputPrefix="geom.out"'   
  write(3,*)' }'   
  write(3,*)'Hamiltonian = DFTB {'
  write(3,*)'  SCC = Yes'
  write(3,*)'  SCCTolerance = 1.0e-8'
  write(3,*)'  MaxSCCIterations = 1000'
  write(3,*)'  Mixer = Broyden {'
  write(3,*)'    MixingParameter = 0.1'
  write(3,*)'    CachedIterations = -1'
  write(3,*)'    InverseJacobiWeight = 0.01'
  write(3,*)'    MinimalWeight = 1.'
  write(3,*)'    MaximalWeight = 100000.'
  write(3,*)'    WeightFactor = 0.01'
  write(3,*)'  }'
  write(3,*)'  SlaterKosterFiles = {'


!   write(3,'(10A3)')(species_name(i), i=1,nsp)     

  do i=1,nsp
    do j=1,nsp
      forprinting=trim(species_name(i)) // '-'
      forprinting=trim(forprinting) // trim(species_name(j))
      forprintingleft= trim(forprinting) // ' ='
      forprintingskf=trim(forprinting) // '.skf"'
      write(3,*)forprintingleft, '"' , forprintingskf
      !write(3,*)species_name(i),'-',species_name(j), '=', '"' , species_name(i) , '-', species_name(j) , '.skf"'
    enddo    
  enddo    

  write(3,*)'  }'
  write(3,*)'  MaxAngularMomentum = {'
!   above we don't need exceptions and all relevant elements are below
  do i=1,nsp
    if(species_name(i).EQ.'H')write(3,*)'H = "s"'
    if(species_name(i).EQ.'He')write(3,*)'He = "s"'
    if(species_name(i).EQ.'Li')write(3,*)'Li = "s"'
    if(species_name(i).EQ.'Be')write(3,*)'Be = "s"'
    if(species_name(i).EQ.'B')write(3,*)'B = "p"'
    if(species_name(i).EQ.'C')write(3,*)'C = "p"'
    if(species_name(i).EQ.'N')write(3,*)'N = "p"'
    if(species_name(i).EQ.'O')write(3,*)'O = "p"'
    if(species_name(i).EQ.'F')write(3,*)'F = "p"'
    if(species_name(i).EQ.'Ne')write(3,*)'Ne = "p"'
    if(species_name(i).EQ.'Na')write(3,*)'Na = "s"'
    if(species_name(i).EQ.'Mg')write(3,*)'Mg = "s"'
    if(species_name(i).EQ.'Al')write(3,*)'Al = "p"'
    if(species_name(i).EQ.'Si')write(3,*)'Si = "p"'
    if(species_name(i).EQ.'P')write(3,*)'P = "p"'
    if(species_name(i).EQ.'S')write(3,*)'S = "p"'
    if(species_name(i).EQ.'Cl')write(3,*)'Cl = "p"'
    if(species_name(i).EQ.'Ar')write(3,*)'Ar = "p"'
    if(species_name(i).EQ.'K')write(3,*)'K = "s"'
    if(species_name(i).EQ.'Ca')write(3,*)'Ca = "p"'
    if(species_name(i).EQ.'Sc')write(3,*)'Sc = "d"'
    if(species_name(i).EQ.'Ti')write(3,*)'Ti = "d"'
    if(species_name(i).EQ.'V')write(3,*)'V = "d"'
    if(species_name(i).EQ.'Cr')write(3,*)'Cr = "d"'
    if(species_name(i).EQ.'Mn')write(3,*)'Mn = "d"'
    if(species_name(i).EQ.'Fe')write(3,*)'Fe = "d"'
    if(species_name(i).EQ.'Co')write(3,*)'Co = "d"'
    if(species_name(i).EQ.'Ni')write(3,*)'Ni = "d"'
    if(species_name(i).EQ.'Cu')write(3,*)'Cu = "d"'
    if(species_name(i).EQ.'Zn')write(3,*)'Zn = "d"'
    if(species_name(i).EQ.'Ga')write(3,*)'Ga = "p"'
    if(species_name(i).EQ.'Ge')write(3,*)'Ge = "p"'
    if(species_name(i).EQ.'As')write(3,*)'As = "p"'
    if(species_name(i).EQ.'Se')write(3,*)'Se = "p"'
    if(species_name(i).EQ.'Br')write(3,*)'Br = "p"'
    if(species_name(i).EQ.'Kr')write(3,*)'Kr = "p"'
    if(species_name(i).EQ.'Rb')write(3,*)'Rb = "s"'
    if(species_name(i).EQ.'Sr')write(3,*)'Sr = "s"'
    if(species_name(i).EQ.'Y')write(3,*)'Y = "d"'
    if(species_name(i).EQ.'Zr')write(3,*)'Zr = "d"'
    if(species_name(i).EQ.'Nb')write(3,*)'Nb = "d"'
    if(species_name(i).EQ.'Mo')write(3,*)'Mo = "d"'
    if(species_name(i).EQ.'Tc')write(3,*)'Tc = "d"'
    if(species_name(i).EQ.'Ru')write(3,*)'Ru = "d"'
    if(species_name(i).EQ.'Rh')write(3,*)'Rh = "d"'
    if(species_name(i).EQ.'Pd')write(3,*)'Pd = "d"'
    if(species_name(i).EQ.'Ag')write(3,*)'Ag = "d"'
    if(species_name(i).EQ.'Cd')write(3,*)'Cd = "d"'
    if(species_name(i).EQ.'In')write(3,*)'In = "p"'
    if(species_name(i).EQ.'Sn')write(3,*)'Sn = "p"'
    if(species_name(i).EQ.'Sb')write(3,*)'Sb = "p"'
    if(species_name(i).EQ.'Te')write(3,*)'Te = "p"'
    if(species_name(i).EQ.'I')write(3,*)'I = "p"'
    if(species_name(i).EQ.'Xe')write(3,*)'Xe = "p"'
    if(species_name(i).EQ.'Cs')write(3,*)'Cs = "s"'
    if(species_name(i).EQ.'Ba')write(3,*)'Ba = "s"'
    if(species_name(i).EQ.'Hf')write(3,*)'Hf = "d"'
    if(species_name(i).EQ.'Ta')write(3,*)'Ta = "d"'
    if(species_name(i).EQ.'W')write(3,*)'W = "d"'
    if(species_name(i).EQ.'Re')write(3,*)'Re = "d"'
    if(species_name(i).EQ.'Os')write(3,*)'Os = "d"'
    if(species_name(i).EQ.'Ir')write(3,*)'Ir = "d"'
    if(species_name(i).EQ.'Pt')write(3,*)'Pt = "d"'
    if(species_name(i).EQ.'Au')write(3,*)'Au = "d"'
    if(species_name(i).EQ.'Hg')write(3,*)'Hg = "d"'
    if(species_name(i).EQ.'Tl')write(3,*)'Tl = "p"'
    if(species_name(i).EQ.'Pb')write(3,*)'Pb = "p"'
    if(species_name(i).EQ.'Bi')write(3,*)'Bi = "p"'
    if(species_name(i).EQ.'Po')write(3,*)'Po = "p"'
    if(species_name(i).EQ.'At')write(3,*)'At = "p"'
    if(species_name(i).EQ.'Rn')write(3,*)'Rn = "p"'
    if(species_name(i).EQ.'Fr')write(3,*)'Fr = "s"'
    if(species_name(i).EQ.'Ra')write(3,*)'Ra = "s"'

  enddo

 write(3,*)'  }'
write(3,*)''
write(3,*)'KPointsAndWeights={'
write(3,*)' 0.0 0.0 0.0 1.0'
write(3,*)'}'
  
  write(3,*)'  Charge = 0.0'
  write(3,*)'  SpinPolarisation = {}'
  write(3,*)'  Filling = Fermi {'
  write(3,*)'    Temperature [k] = 300 '
  write(3,*)'  }'
  write(3,*)'  ElectricField = {}'
  write(3,*)'  OrbitalResolvedSCC = No'
  write(3,*)'  ReadInitialCharges =  No' 
  write(3,*)'  Eigensolver = DivideAndConquer {}'
  write(3,*)'  OldSKInterpolation = No'
!  write(3,*)'  OrbitalPotential = {}'
  write(3,*)'  Dispersion = {}'
  write(3,*)'}'
  write(3,*)'Options = {'
  write(3,*)'#  CalculateForces = Yes'
  write(3,*)'  WriteEigenvectors = No'
  write(3,*)'  WriteAutotestTag = Yes '
  write(3,*)'  WriteDetailedXML = Yes '
  write(3,*)'  WriteResultsTag = Yes '
  write(3,*)'  WriteDetailedOut = Yes'
  write(3,*)'  WriteBandOut = Yes'
  write(3,*)'  AtomResolvedEnergies = No'
  write(3,*)'#  RestartFrequency = 20'
  write(3,*)'  RandomSeed = 0'
  write(3,*)'}'
  write(3,*)'ParserOptions = {'
  write(3,*)'  ParserVersion = 3'
  write(3,*)'  WriteHSDInput = Yes'
  write(3,*)'  WriteXMLInput = No'
  write(3,*)'  StopAfterParsing = No'
  write(3,*)'}'


     
end
	
