#!/bin/bash

#periodictable_forsearch.txt needs to be two folders back
periodictable_forsearch=$HOME/DFTB_version_1_3/DFTBscriptfiles_noexecutable/periodictable_forsearch.txt

for skf in *.skf
do
	twoElementsDash=$(basename $skf .skf)
	twoElements=$( echo $twoElementsDash | sed 's/-/ /g' )
	sed -i.backup '1s/,/ /g' $skf #remove all commas from the .skf top line
	numberOfThingsOnFirstLine=$(head -n 1 $skf | wc -w)
	secondNumberOnFirstLine=$(head -n 1 $skf | awk '{ print $2 }' )
	whereSplineIs=$( grep -n Spline $skf | tr -d ':Spline' )
	#https://www.researchgate.net/post/Having_problems_running_dftb_on_Gaussian_09_G09_version_rev_B01_and_C01
	firstElement=$( echo $twoElements | awk '{ print $1 }' )
	secondElement=$( echo $twoElements | awk '{ print $NF }' )
	
	#edit Spline line and if necessary remove unnecessary things from first line
	if [ "$firstElement" = "$secondElement" ] #if X-X.skf type (homonuclear)
	then
		if [[ $numberOfThingsOnFirstLine = 3 ]] #3 things on the line is unnecessary for X-X.skf type (homonuclear)
		then
			#removeThisThing=", "
			#removeThisThing=",  "
			removeThisThing=" "
			removeThisThing+=$( head -n 1 $skf | awk '{ print $3 }' )
			sed -i.bk "1s/$removeThisThing//" $skf
		fi
		whereSplineIs=$( echo " $whereSplineIs - 3 " | bc )
		sed -i.bk "1s/$secondNumberOnFirstLine/$whereSplineIs/g" $skf
	else #it is a X-Y.skf type (heteronuclear) 
		whereSplineIs=$( echo " $whereSplineIs - 2 " | bc )
		sed -i.bk "1s/$secondNumberOnFirstLine/$whereSplineIs/g" $skf
	fi

	#add atomic number labels

	atomicNumberFirst=$( grep " $firstElement " $periodictable_forsearch | awk '{ print $3  }' )
	atomicNumberSecond=$( grep " $secondElement " $periodictable_forsearch | awk '{ print $3  }' )
	sed -i.bk "1s/$/ $atomicNumberFirst $atomicNumberSecond/" $skf 

done
rm *bk #not backup

#undo this with for f in *backup ; do mv $f $(basename $f .backup) ; done

